<?php
class Security {
    private $max_attempts = 5;
    private $lockout_time = 900; // 15 minutes
    
    public function checkRateLimit($username) {
        $db = new Database();
        
        $sql = "SELECT failed_attempts, last_login FROM admin_users WHERE username = ?";
        $params = [$username];
        $stmt = $db->prepare($sql, $params);
        
        if ($db->execute($stmt) && $user = $db->fetchArray($stmt)) {
            if ($user['failed_attempts'] >= $this->max_attempts && $user['last_login']) {
                $last_attempt = strtotime($user['last_login']->format('Y-m-d H:i:s'));
                $current_time = time();
                
                if (($current_time - $last_attempt) < $this->lockout_time) {
                    return true; // Still locked out
                }
            }
        }
        
        return false;
    }
    
    public function logActivity($userId, $action, $description) {
        $db = new Database();
        $ip_address = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
        $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
        
        $sql = "INSERT INTO admin_activity_log (user_id, action, description, ip_address, user_agent) 
                VALUES (?, ?, ?, ?, ?)";
        $params = [$userId, $action, $description, $ip_address, $user_agent];
        $stmt = $db->prepare($sql, $params);
        
        if ($stmt) {
            $db->execute($stmt);
        }
    }
    
    public function sanitizeInput($input) {
        return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
    }
    
    public function verifyCSRFToken() {
        if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
            die('CSRF token validation failed');
        }
    }
    
    public function generateCSRFToken() {
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf_token'];
    }
}
?>